package com.agilex.healthcare.directscheduling.linkbuilder;

import java.net.URI;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriBuilder;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.utility.NullChecker;

@Service
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class DirectSchedulingResourceDirectoryBuilder {
	
	public ResourceDirectory getResourceDirectory(URI systemBaseUri, String siteCode, String assigningAuthority, String patientId){
		
		if(NullChecker.isNullish(siteCode)){
			throw new WebApplicationException(Status.BAD_REQUEST);
		}
		
		ResourceDirectory resourceDirectory = new ResourceDirectory();
		
		AtomLink link;
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling").path("directscheduling-resource-directory").build());
		link.setTitle("directscheduling-resource-directory"); 
		resourceDirectory.getLink().setSelfLink(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("site").path(siteCode)
														.path("patient").path(assigningAuthority).path(patientId)
														.path("available-appointment-slots").build());
		link.setTitle("ds-appointment-slots");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("site").path(siteCode)
														.path("patient").path(assigningAuthority).path(patientId)
														.path("cancel-appointment").build());
		link.setTitle("ds-cancel-appointments");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("site").path(siteCode)
														.path("patient").path(assigningAuthority).path(patientId)
														.path("cancel-reasons-list").build());
		link.setTitle("ds-cancel-reasons-list");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("site").path(siteCode)
														.path("purpose-list").build());
		link.setTitle("ds-purpose-list");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("site").path(siteCode)
														.path("patient").path(assigningAuthority).path(patientId)
														.path("booked-appointments").build());
		link.setTitle("ds-booked-appointments");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("site").path(siteCode)
														.path("logout").build());
		link.setTitle("ds-logout");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("booking-confirmation").build());
		link.setTitle("booking-confirmation");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("cancel-confirmation").build());
		link.setTitle("cancel-confirmation");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("patient").path(assigningAuthority).path(patientId).path("facility-provider").build());
		link.setTitle("facility-provider");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("patient").path(assigningAuthority).path(patientId).path("facility-provider-view").build());
		link.setTitle("facility-provider-view");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling")
														.path("patient").path(assigningAuthority).path(patientId).path("facility-provider-all").build());
		link.setTitle("facility-provider-all");
		resourceDirectory.getLink().add(link);
		
		return resourceDirectory;
	}
}
